/*****************************************************************************
*	FILENAME:		gcpijepg.h
*	COPYRIGHT(c) 2002 Symbol Technologies Inc.  All rights reserved
*
*	DESCRIPTION:	Jpeg file header processing routines  
*						
*
*	NOTES:
*	
*	AUTHOR:			A.Schuessler
*	CREATION DATE: 10/28/02
*	DERIVED FROM:	Copied entirely from file of same name from Mike O'Haire for GCP project.
*
*	EDIT HISTORY:
*	$Log:   U:/SSI_SDK/archives/SSI_SDKv2.0/ssi_sdk/ssidll/GCPJPEG.CPP-arc  $
 * 
 *    Rev 1.0   Nov 22 2002 13:25:46   fitzsimj
 * Initial revision.
 * 
 *    Rev 1.0   Oct 28 2002 14:38:48   schuesla
 * Initial revision.
*
*****************************************************************************/


//---------------------------------------------------------------------------
#include "stdafx.h"
#include "gcpjpeg.h"


//---------------------------------------------------------------------------

char DCTOrder[64] =
{
    0,  1,  8, 16,  9,  2,  3, 10,
    17, 24, 32, 25, 18, 11,  4,  5,
    12, 19, 26, 33, 40, 48, 41, 34,
    27, 20, 13,  6,  7, 14, 21, 28,
    35, 42, 49, 56, 57, 50, 43, 36,
    29, 22, 15, 23, 30, 37, 44, 51,
    58, 59, 52, 45, 38, 31, 39, 46,
    53, 60, 61, 54, 47, 55, 62, 63
};

char JPEGLuminanceQuant[64] =
{
    16,  11,  10,  16,  24,  40,  51,  61,
    12,  12,  14,  19,  26,  58,  60,  55,
    14,  13,  16,  24,  40,  57,  69,  56,
    14,  17,  22,  29,  51,  87,  80,  62,
    18,  22,  37,  56,  68, 109, 103,  77,
    24,  35,  55,  64,  81, 104, 113,  92,
    49,  64,  78,  87, 103, 121, 120, 101,
    72,  92,  95,  98, 112, 100, 103,  99
};

unsigned char JPEGHeader[JPEG_FILE_HEADER_SIZE] =
{
    0xff, 0xd8,
    0xff, 0xe0, 0x00, 0x10, 0x4a, 0x46, 0x49, 0x46, 0x00,
    1, 1, 0, 0, 1, 0, 1, 0, 0,

    0xff, 0xdb, 0x00, 0x43, 0,
//    (* Quantization Table - 64 entries*)
//    (* Offset $19 *)
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,

    0xff, 0xc4, 0x00, 0x1f,
    0x00,  //(* DC Table *)
//    (* DC Luminance bits *)
    0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
//    (* DC Luminance Values *)
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,

    0xff, 0xc4, 0x00, 0xb5,
    0x10, //(* AC Table *)

//    (* AC Luminance bits *)
    0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 0x7d,
//    (* AC Luminance Values *)
    0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12,
    0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
    0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08,
    0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
    0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
    0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
    0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
    0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
    0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
    0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
    0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
    0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
    0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
    0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
    0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4,
    0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
    0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
    0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xf9, 0xfa
};

unsigned char BmpHeader[BMP_HEADER_SIZE] =
{
   0x42, 0x4D, 0x36, 0xB4, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x36, 0x04, 0x00, 0x00, 0x28, 0x00,
   0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0xE0, 0x01,
   0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x02, 0x02,
   0x02, 0x00, 0x03, 0x03, 0x03, 0x00, 0x04, 0x04,
   0x04, 0x00, 0x05, 0x05, 0x05, 0x00, 0x06, 0x06,
   0x06, 0x00, 0x07, 0x07, 0x07, 0x00, 0x08, 0x08,
   0x08, 0x00, 0x09, 0x09, 0x09, 0x00, 0x0A, 0x0A,
   0x0A, 0x00, 0x0B, 0x0B, 0x0B, 0x00, 0x0C, 0x0C,
   0x0C, 0x00, 0x0D, 0x0D, 0x0D, 0x00, 0x0E, 0x0E,
   0x0E, 0x00, 0x0F, 0x0F, 0x0F, 0x00, 0x10, 0x10,
   0x10, 0x00, 0x11, 0x11, 0x11, 0x00, 0x12, 0x12,
   0x12, 0x00, 0x13, 0x13, 0x13, 0x00, 0x14, 0x14,
   0x14, 0x00, 0x15, 0x15, 0x15, 0x00, 0x16, 0x16,
   0x16, 0x00, 0x17, 0x17, 0x17, 0x00, 0x18, 0x18,
   0x18, 0x00, 0x19, 0x19, 0x19, 0x00, 0x1A, 0x1A,
   0x1A, 0x00, 0x1B, 0x1B, 0x1B, 0x00, 0x1C, 0x1C,
   0x1C, 0x00, 0x1D, 0x1D, 0x1D, 0x00, 0x1E, 0x1E,
   0x1E, 0x00, 0x1F, 0x1F, 0x1F, 0x00, 0x20, 0x20,
   0x20, 0x00, 0x21, 0x21, 0x21, 0x00, 0x22, 0x22,
   0x22, 0x00, 0x23, 0x23, 0x23, 0x00, 0x24, 0x24,
   0x24, 0x00, 0x25, 0x25, 0x25, 0x00, 0x26, 0x26,
   0x26, 0x00, 0x27, 0x27, 0x27, 0x00, 0x28, 0x28,
   0x28, 0x00, 0x29, 0x29, 0x29, 0x00, 0x2A, 0x2A,
   0x2A, 0x00, 0x2B, 0x2B, 0x2B, 0x00, 0x2C, 0x2C,
   0x2C, 0x00, 0x2D, 0x2D, 0x2D, 0x00, 0x2E, 0x2E,
   0x2E, 0x00, 0x2F, 0x2F, 0x2F, 0x00, 0x30, 0x30,
   0x30, 0x00, 0x31, 0x31, 0x31, 0x00, 0x32, 0x32,
   0x32, 0x00, 0x33, 0x33, 0x33, 0x00, 0x34, 0x34,
   0x34, 0x00, 0x35, 0x35, 0x35, 0x00, 0x36, 0x36,
   0x36, 0x00, 0x37, 0x37, 0x37, 0x00, 0x38, 0x38,
   0x38, 0x00, 0x39, 0x39, 0x39, 0x00, 0x3A, 0x3A,
   0x3A, 0x00, 0x3B, 0x3B, 0x3B, 0x00, 0x3C, 0x3C,
   0x3C, 0x00, 0x3D, 0x3D, 0x3D, 0x00, 0x3E, 0x3E,
   0x3E, 0x00, 0x3F, 0x3F, 0x3F, 0x00, 0x40, 0x40,
   0x40, 0x00, 0x41, 0x41, 0x41, 0x00, 0x42, 0x42,
   0x42, 0x00, 0x43, 0x43, 0x43, 0x00, 0x44, 0x44,
   0x44, 0x00, 0x45, 0x45, 0x45, 0x00, 0x46, 0x46,
   0x46, 0x00, 0x47, 0x47, 0x47, 0x00, 0x48, 0x48,
   0x48, 0x00, 0x49, 0x49, 0x49, 0x00, 0x4A, 0x4A,
   0x4A, 0x00, 0x4B, 0x4B, 0x4B, 0x00, 0x4C, 0x4C,
   0x4C, 0x00, 0x4D, 0x4D, 0x4D, 0x00, 0x4E, 0x4E,
   0x4E, 0x00, 0x4F, 0x4F, 0x4F, 0x00, 0x50, 0x50,
   0x50, 0x00, 0x51, 0x51, 0x51, 0x00, 0x52, 0x52,
   0x52, 0x00, 0x53, 0x53, 0x53, 0x00, 0x54, 0x54,
   0x54, 0x00, 0x55, 0x55, 0x55, 0x00, 0x56, 0x56,
   0x56, 0x00, 0x57, 0x57, 0x57, 0x00, 0x58, 0x58,
   0x58, 0x00, 0x59, 0x59, 0x59, 0x00, 0x5A, 0x5A,
   0x5A, 0x00, 0x5B, 0x5B, 0x5B, 0x00, 0x5C, 0x5C,
   0x5C, 0x00, 0x5D, 0x5D, 0x5D, 0x00, 0x5E, 0x5E,
   0x5E, 0x00, 0x5F, 0x5F, 0x5F, 0x00, 0x60, 0x60,
   0x60, 0x00, 0x61, 0x61, 0x61, 0x00, 0x62, 0x62,
   0x62, 0x00, 0x63, 0x63, 0x63, 0x00, 0x64, 0x64,
   0x64, 0x00, 0x65, 0x65, 0x65, 0x00, 0x66, 0x66,
   0x66, 0x00, 0x67, 0x67, 0x67, 0x00, 0x68, 0x68,
   0x68, 0x00, 0x69, 0x69, 0x69, 0x00, 0x6A, 0x6A,
   0x6A, 0x00, 0x6B, 0x6B, 0x6B, 0x00, 0x6C, 0x6C,
   0x6C, 0x00, 0x6D, 0x6D, 0x6D, 0x00, 0x6E, 0x6E,
   0x6E, 0x00, 0x6F, 0x6F, 0x6F, 0x00, 0x70, 0x70,
   0x70, 0x00, 0x71, 0x71, 0x71, 0x00, 0x72, 0x72,
   0x72, 0x00, 0x73, 0x73, 0x73, 0x00, 0x74, 0x74,
   0x74, 0x00, 0x75, 0x75, 0x75, 0x00, 0x76, 0x76,
   0x76, 0x00, 0x77, 0x77, 0x77, 0x00, 0x78, 0x78,
   0x78, 0x00, 0x79, 0x79, 0x79, 0x00, 0x7A, 0x7A,
   0x7A, 0x00, 0x7B, 0x7B, 0x7B, 0x00, 0x7C, 0x7C,
   0x7C, 0x00, 0x7D, 0x7D, 0x7D, 0x00, 0x7E, 0x7E,
   0x7E, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x80, 0x80,
   0x80, 0x00, 0x81, 0x81, 0x81, 0x00, 0x82, 0x82,
   0x82, 0x00, 0x83, 0x83, 0x83, 0x00, 0x84, 0x84,
   0x84, 0x00, 0x85, 0x85, 0x85, 0x00, 0x86, 0x86,
   0x86, 0x00, 0x87, 0x87, 0x87, 0x00, 0x88, 0x88,
   0x88, 0x00, 0x89, 0x89, 0x89, 0x00, 0x8A, 0x8A,
   0x8A, 0x00, 0x8B, 0x8B, 0x8B, 0x00, 0x8C, 0x8C,
   0x8C, 0x00, 0x8D, 0x8D, 0x8D, 0x00, 0x8E, 0x8E,
   0x8E, 0x00, 0x8F, 0x8F, 0x8F, 0x00, 0x90, 0x90,
   0x90, 0x00, 0x91, 0x91, 0x91, 0x00, 0x92, 0x92,
   0x92, 0x00, 0x93, 0x93, 0x93, 0x00, 0x94, 0x94,
   0x94, 0x00, 0x95, 0x95, 0x95, 0x00, 0x96, 0x96,
   0x96, 0x00, 0x97, 0x97, 0x97, 0x00, 0x98, 0x98,
   0x98, 0x00, 0x99, 0x99, 0x99, 0x00, 0x9A, 0x9A,
   0x9A, 0x00, 0x9B, 0x9B, 0x9B, 0x00, 0x9C, 0x9C,
   0x9C, 0x00, 0x9D, 0x9D, 0x9D, 0x00, 0x9E, 0x9E,
   0x9E, 0x00, 0x9F, 0x9F, 0x9F, 0x00, 0xA0, 0xA0,
   0xA0, 0x00, 0xA1, 0xA1, 0xA1, 0x00, 0xA2, 0xA2, 
   0xA2, 0x00, 0xA3, 0xA3, 0xA3, 0x00, 0xA4, 0xA4,
   0xA4, 0x00, 0xA5, 0xA5, 0xA5, 0x00, 0xA6, 0xA6, 
   0xA6, 0x00, 0xA7, 0xA7, 0xA7, 0x00, 0xA8, 0xA8,
   0xA8, 0x00, 0xA9, 0xA9, 0xA9, 0x00, 0xAA, 0xAA,
   0xAA, 0x00, 0xAB, 0xAB, 0xAB, 0x00, 0xAC, 0xAC,
   0xAC, 0x00, 0xAD, 0xAD, 0xAD, 0x00, 0xAE, 0xAE,
   0xAE, 0x00, 0xAF, 0xAF, 0xAF, 0x00, 0xB0, 0xB0,
   0xB0, 0x00, 0xB1, 0xB1, 0xB1, 0x00, 0xB2, 0xB2,
   0xB2, 0x00, 0xB3, 0xB3, 0xB3, 0x00, 0xB4, 0xB4,
   0xB4, 0x00, 0xB5, 0xB5, 0xB5, 0x00, 0xB6, 0xB6,
   0xB6, 0x00, 0xB7, 0xB7, 0xB7, 0x00, 0xB8, 0xB8,
   0xB8, 0x00, 0xB9, 0xB9, 0xB9, 0x00, 0xBA, 0xBA,
   0xBA, 0x00, 0xBB, 0xBB, 0xBB, 0x00, 0xBC, 0xBC,
   0xBC, 0x00, 0xBD, 0xBD, 0xBD, 0x00, 0xBE, 0xBE, 
   0xBE, 0x00, 0xBF, 0xBF, 0xBF, 0x00, 0xC0, 0xC0, 
   0xC0, 0x00, 0xC1, 0xC1, 0xC1, 0x00, 0xC2, 0xC2,
   0xC2, 0x00, 0xC3, 0xC3, 0xC3, 0x00, 0xC4, 0xC4,
   0xC4, 0x00, 0xC5, 0xC5, 0xC5, 0x00, 0xC6, 0xC6,
   0xC6, 0x00, 0xC7, 0xC7, 0xC7, 0x00, 0xC8, 0xC8,
   0xC8, 0x00, 0xC9, 0xC9, 0xC9, 0x00, 0xCA, 0xCA,
   0xCA, 0x00, 0xCB, 0xCB, 0xCB, 0x00, 0xCC, 0xCC,
   0xCC, 0x00, 0xCD, 0xCD, 0xCD, 0x00, 0xCE, 0xCE,
   0xCE, 0x00, 0xCF, 0xCF, 0xCF, 0x00, 0xD0, 0xD0,
   0xD0, 0x00, 0xD1, 0xD1, 0xD1, 0x00, 0xD2, 0xD2,
   0xD2, 0x00, 0xD3, 0xD3, 0xD3, 0x00, 0xD4, 0xD4,
   0xD4, 0x00, 0xD5, 0xD5, 0xD5, 0x00, 0xD6, 0xD6,
   0xD6, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD8, 0xD8,
   0xD8, 0x00, 0xD9, 0xD9, 0xD9, 0x00, 0xDA, 0xDA,
   0xDA, 0x00, 0xDB, 0xDB, 0xDB, 0x00, 0xDC, 0xDC, 
   0xDC, 0x00, 0xDD, 0xDD, 0xDD, 0x00, 0xDE, 0xDE, 
   0xDE, 0x00, 0xDF, 0xDF, 0xDF, 0x00, 0xE0, 0xE0,
   0xE0, 0x00, 0xE1, 0xE1, 0xE1, 0x00, 0xE2, 0xE2,
   0xE2, 0x00, 0xE3, 0xE3, 0xE3, 0x00, 0xE4, 0xE4,
   0xE4, 0x00, 0xE5, 0xE5, 0xE5, 0x00, 0xE6, 0xE6,
   0xE6, 0x00, 0xE7, 0xE7, 0xE7, 0x00, 0xE8, 0xE8,
   0xE8, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0xEA, 0xEA,
   0xEA, 0x00, 0xEB, 0xEB, 0xEB, 0x00, 0xEC, 0xEC,
   0xEC, 0x00, 0xED, 0xED, 0xED, 0x00, 0xEE, 0xEE,
   0xEE, 0x00, 0xEF, 0xEF, 0xEF, 0x00, 0xF0, 0xF0,
   0xF0, 0x00, 0xF1, 0xF1, 0xF1, 0x00, 0xF2, 0xF2,
   0xF2, 0x00, 0xF3, 0xF3, 0xF3, 0x00, 0xF4, 0xF4,
   0xF4, 0x00, 0xF5, 0xF5, 0xF5, 0x00, 0xF6, 0xF6,
   0xF6, 0x00, 0xF7, 0xF7, 0xF7, 0x00, 0xF8, 0xF8,
   0xF8, 0x00, 0xF9, 0xF9, 0xF9, 0x00, 0xFA, 0xFA,
   0xFA, 0x00, 0xFB, 0xFB, 0xFB, 0x00, 0xFC, 0xFC,
   0xFC, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0xFE, 0xFE,
   0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0x00
};

//
// JPEGQualityToScale( Quality: integer )
//
// Convert a user-specified quality rating to a percentage scaling factor
// for an underlying quantization table, using our recommended scaling curve.
// The input 'quality' factor should be 0 (terrible) to 100 (very good).
//

int JPEGQualityToScale( int Quality)
{
   int Result;
  // Safety limit on quality factor.  Convert 0 to 1 to avoid zero divide. *)

  if( Quality <= 0)
        Quality = 1;
  if (Quality > 100)
        Quality = 100;

  // The basic table is used as-is (scaling 100) for a quality of 50.
  // Qualities 50..100 are converted to scaling percentage 200 - 2*Q;
  // note that at Q=100 the scaling is 0, which will cause jpeg_add_quant_table
  // to make all the table entries 1 (hence, minimum quantization loss).
  // Qualities 1..50 are converted to scaling percentage 5000/Q.
  //
  if (Quality < 50)
    Result = 5000 / Quality;
  else
    Result = 200 - (Quality * 2);

    return( Result );
};

void StuffJPEGQuantTable( unsigned char *QuantTable, int Quality)
{
   int i, Value, Scale;
   
   Scale = JPEGQualityToScale( Quality );
   for( i = 0; i <= 63; i++)
   {
      Value = (JPEGLuminanceQuant[ DCTOrder[i] ] * Scale + 50) / 100;
      if( Value < 0 )
         Value = 0;
      else if (Value > 255)
         Value = 255;

      QuantTable[ i ] = Value & 0xff;
   };
};



int BuildHeader(unsigned char *Original, unsigned char *Updated, int PacketLength)
{
        // Make header
        StuffJPEGQuantTable( &JPEGHeader[ JPEG_QUANT_OFFSET ], UNPACK_WORD( &Original[ 0 ] ) );

        // Place Header into Updated Buffer
        memcpy(Updated, JPEGHeader, JPEG_FILE_HEADER_SIZE);

        // Place Original Image after header
        memcpy(&Updated[JPEG_FILE_HEADER_SIZE], &Original[2], PacketLength - 2);

        // Now tag the end of the buffer with JPEG EOI record
        Updated[JPEG_FILE_HEADER_SIZE + PacketLength - 2] = 0xff;
        Updated[JPEG_FILE_HEADER_SIZE + PacketLength - 1] = 0xd9;

        // Now return length of image
        return(PacketLength + JPEG_FILE_HEADER_SIZE);
}
